/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.flag.FlagTag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class FlagMessage
implements INbtSerializable<class_2487> {
    public static final String FLAG_TEMPLATE = "{flag}";
    public static final String POS_TEMPLATE = "{pos}";
    public static final String REGION_TEMPLATE = "{region}";
    public static final String DIM_TEMPLATE = "{dim}";
    public static final String PLAYER_TEMPLATE = "{player}";
    public static final String CONFIG_MSG = "config";
    public static final Set<String> MSG_TOKEN;
    public static FlagMessage DEFAULT_FLAG_MSG;
    private String msg;
    private boolean muted;
    private boolean isDefault;

    public FlagMessage(String msg) {
        this.msg = msg;
        this.isDefault = msg.toLowerCase(Locale.ROOT).equals(CONFIG_MSG);
    }

    public FlagMessage(String msg, boolean muted) {
        this(msg);
        this.muted = muted;
    }

    public FlagMessage(class_2487 msgNbt) {
        this.deserializeNBT(msgNbt);
    }

    public static Map<String, String> defaultSubstitutes(RegionFlag flag, IProtectedRegion region, class_2338 pos, @Nullable class_1657 player) {
        HashMap<String, String> substituteMap = new HashMap<String, String>();
        substituteMap.put(FLAG_TEMPLATE, flag.name);
        substituteMap.put(POS_TEMPLATE, ChatComponentBuilder.shortBlockPosBracketed(pos));
        substituteMap.put(REGION_TEMPLATE, region.getName());
        substituteMap.put(DIM_TEMPLATE, region.getDim().method_29177().toString());
        if (player != null && flag.categories.contains((Object)FlagTag.PLAYER)) {
            substituteMap.put(PLAYER_TEMPLATE, player.method_5820());
        }
        return substituteMap;
    }

    public static Map<String, String> defaultSubstitutesFor(FlagCheckResult result) {
        HashMap<String, String> substituteMap = new HashMap<String, String>();
        substituteMap.put(FLAG_TEMPLATE, result.getFlagCheck().getRegionFlag().name);
        substituteMap.put(POS_TEMPLATE, ChatComponentBuilder.tinyBlockPos(result.getFlagCheck().getTarget()));
        substituteMap.put(REGION_TEMPLATE, result.getResponsible().getName());
        substituteMap.put(DIM_TEMPLATE, result.getResponsible().getDim().method_29177().toString());
        if (result.getFlagCheck().getPlayer() != null && RegionFlag.hasPlayerCategory(result.getFlagCheck().getRegionFlag())) {
            substituteMap.put(PLAYER_TEMPLATE, result.getFlagCheck().getPlayer().method_5820());
        }
        return substituteMap;
    }

    public static class_5250 buildFrom(FlagCheckResult result, Map<String, String> substitutes) {
        String flagMsgTemplate = result.getFlag().getFlagMsg().isDefault() ? FlagMessage.getI18nFlagMsgTemplate(result) : result.getFlag().getFlagMsg().msg();
        String flagMsg = FlagMessage.replaceMatches(flagMsgTemplate, substitutes);
        return class_2561.method_43470((String)flagMsg);
    }

    private static String getI18nFlagMsgTemplate(FlagCheckResult result) {
        String flagMsgLangKey = "flag.msg.deny." + result.getFlag().getName();
        String fallBackLangKey = "flag.msg.deny." + result.getResponsible().getRegionType().type + ".default";
        return class_2561.method_48321((String)flagMsgLangKey, (String)fallBackLangKey).getString();
    }

    private static String replaceMatches(String flagMsgTemplate, Map<String, String> substitutes) {
        String flagMsg = flagMsgTemplate;
        for (Map.Entry<String, String> entry : substitutes.entrySet()) {
            flagMsg = flagMsg.replace(entry.getKey(), entry.getValue());
        }
        return flagMsg;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void mute(boolean mute) {
        this.muted = mute;
    }

    public void reset() {
        this.isDefault = true;
        this.msg = CONFIG_MSG;
    }

    public boolean isDefault() {
        return this.msg.equals(CONFIG_MSG);
    }

    public String msg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return this.msg;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("msg", this.msg);
        nbt.method_10556("default", this.isDefault);
        nbt.method_10556("muted", this.muted);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.msg = nbt.method_10558("msg");
        this.muted = nbt.method_10577("muted");
        this.isDefault = nbt.method_10577("default");
    }

    static {
        DEFAULT_FLAG_MSG = new FlagMessage(CONFIG_MSG);
        MSG_TOKEN = new HashSet<String>();
        MSG_TOKEN.add(FLAG_TEMPLATE);
        MSG_TOKEN.add(REGION_TEMPLATE);
        MSG_TOKEN.add("{dimension}");
        MSG_TOKEN.add(POS_TEMPLATE);
        MSG_TOKEN.add(PLAYER_TEMPLATE);
        MSG_TOKEN.add("{team}");
        MSG_TOKEN.add("{group}");
        MSG_TOKEN.add("{entity}");
        MSG_TOKEN.add("{block}");
    }
}

